<?php
include('connection.php');
session_start();

// Variables for pagination
$limit = 10; // Number of records per page
$page = isset($_GET['page']) ? $_GET['page'] : 1;
$start = ($page - 1) * $limit;

// Variables for search criteria
$search = isset($_GET['search']) ? $_GET['search'] : '';
$class_filter = isset($_GET['class']) ? $_GET['class'] : '';
$date_filter = isset($_GET['date']) ? $_GET['date'] : '';

// Initialize result variable
$result = null;

// SQL query to fetch attendance records based on search criteria
$searchQuery = "SELECT a.registration_number, s.full_name, a.date, a.status, a.sickness, a.class_teacher_name, a.class 
                FROM attendance a 
                JOIN students s ON a.registration_number = s.registration_number 
                WHERE (a.registration_number LIKE ? OR s.full_name LIKE ? OR a.class LIKE ?)
                AND (? = '' OR a.date = ?)
                LIMIT ?, ?";

// Prepare and execute the SQL query if there's a search
if ($search || $class_filter || $date_filter) {
    $stmt = $con->prepare($searchQuery);
    $searchTerm = "%$search%";
    $classTerm = "%$class_filter%";
    $stmt->bind_param("sssssss", $searchTerm, $searchTerm, $classTerm, $date_filter, $date_filter, $start, $limit);
    $stmt->execute();
    $result = $stmt->get_result();

    // Count total records for pagination
    $countQuery = "SELECT COUNT(*) AS total FROM attendance a 
                   JOIN students s ON a.registration_number = s.registration_number 
                   WHERE (a.registration_number LIKE ? OR s.full_name LIKE ? OR a.class LIKE ?)
                   AND (? = '' OR a.date = ?)";
    $countStmt = $con->prepare($countQuery);
    $countStmt->bind_param("sssss", $searchTerm, $searchTerm, $classTerm, $date_filter, $date_filter);
    $countStmt->execute();
    $countResult = $countStmt->get_result();
    $totalRecords = $countResult->fetch_assoc()['total'];
    $totalPages = ceil($totalRecords / $limit);
}

// Handle "Delete All" request
if (isset($_POST['delete_all'])) {
    $deleteQuery = "DELETE FROM attendance";
    if ($con->query($deleteQuery)) {
        echo "<div class='alert alert-success'>All attendance records have been deleted successfully.</div>";
    } else {
        echo "<div class='alert alert-danger'>Error deleting records: " . $con->error . "</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - View Attendance</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-5">
    <h2>Attendance Records</h2>

    <!-- Search Form -->
    <form class="form-inline mb-4" method="GET" action="">
        <input type="text" name="search" class="form-control mr-2" placeholder="Search by Reg Number or Name" value="<?php echo htmlspecialchars($search); ?>">
        <select name="class" class="form-control mr-2">
            <option value="" selected disabled>Select Class</option>
            <option value="Form One" <?php if ($class_filter == 'Form One') echo 'selected'; ?>>Form One</option>
            <option value="Form Two" <?php if ($class_filter == 'Form Two') echo 'selected'; ?>>Form Two</option>
            <option value="Form Three" <?php if ($class_filter == 'Form Three') echo 'selected'; ?>>Form Three</option>
            <option value="Form Four" <?php if ($class_filter == 'Form Four') echo 'selected'; ?>>Form Four</option>
        </select>
        <input type="date" name="date" class="form-control mr-2" value="<?php echo htmlspecialchars($date_filter); ?>">
        <button type="submit" class="btn btn-primary">Search</button>
    </form>

    <!-- Delete All Records Button -->
    <form method="POST" action="" id="delete-all-form">
        <input type="hidden" name="delete_all" value="1">
        <button type="button" class="btn btn-danger mb-4" id="delete-all-btn">Delete All Records</button>
    </form>

    <!-- Attendance Table -->
    <?php if ($search || $class_filter || $date_filter): ?>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Registration Number</th>
                    <th>Full Name</th>
                    <th>Date</th>
                    <th>Status</th>
                    <th>Sickness</th>
                    <th>Class Teacher</th>
                    <th>Class</th>
                </tr>
            </thead>
            <tbody>
            <?php if ($result && $result->num_rows > 0): ?>
                <?php while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo $row['registration_number']; ?></td>
                        <td><?php echo $row['full_name']; ?></td>
                        <td><?php echo $row['date']; ?></td>
                        <td><?php echo $row['status']; ?></td>
                        <td><?php echo $row['sickness'] ? $row['sickness'] : 'N/A'; ?></td>
                        <td><?php echo $row['class_teacher_name']; ?></td>
                        <td><?php echo $row['class']; ?></td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="7" class="text-center">No attendance records found.</td>
                </tr>
            <?php endif; ?>
            </tbody>
        </table>

        <!-- Pagination Links -->
        <nav>
            <ul class="pagination justify-content-center">
                <li class="page-item <?php if ($page == 1) echo 'disabled'; ?>">
                    <a class="page-link" href="?search=<?php echo $search; ?>&class=<?php echo $class_filter; ?>&date=<?php echo $date_filter; ?>&page=<?php echo $page - 1; ?>">Previous</a>
                </li>
                <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                    <li class="page-item <?php if ($i == $page) echo 'active'; ?>">
                        <a class="page-link" href="?search=<?php echo $search; ?>&class=<?php echo $class_filter; ?>&date=<?php echo $date_filter; ?>&page=<?php echo $i; ?>"><?php echo $i; ?></a>
                    </li>
                <?php endfor; ?>
                <li class="page-item <?php if ($page == $totalPages) echo 'disabled'; ?>">
                    <a class="page-link" href="?search=<?php echo $search; ?>&class=<?php echo $class_filter; ?>&date=<?php echo $date_filter; ?>&page=<?php echo $page + 1; ?>">Next</a>
                </li>
            </ul>
        </nav>
    <?php endif; ?>
</div>

<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script>
    // Confirmation dialog for deleting all records
    document.getElementById('delete-all-btn').addEventListener('click', function() {
        if (confirm('Are you sure you want to delete all attendance records? This action cannot be undone.')) {
            document.getElementById('delete-all-form').submit();
        }
    });
</script>
</body>
</html>
